function normalizeFilePath(filePath) {
  return (filePath || '').replace(/\\/g, '/');
}

function formatFileSize(bytes) {
  if (bytes === 0) return '0 Bytes';
  const k = 1024;
  const sizes = ['Bytes', 'KB', 'MB', 'GB'];
  const i = Math.floor(Math.log(bytes) / Math.log(k));
  return Math.round((bytes / Math.pow(k, i)) * 100) / 100 + ' ' + sizes[i];
}

function formatDate(date) {
  return new Date(date).toLocaleString();
}

function formatTimestamp(seconds, fractionDigits = 2) {
  if (!Number.isFinite(seconds) || seconds < 0) {
    seconds = 0;
  }

  const multiplier = Math.pow(10, fractionDigits);
  const roundedSeconds = Math.round(seconds * multiplier) / multiplier;
  const wholeSeconds = Math.floor(roundedSeconds);
  const fractional = Math.round((roundedSeconds - wholeSeconds) * multiplier);

  const hours = Math.floor(wholeSeconds / 3600);
  const minutes = Math.floor((wholeSeconds % 3600) / 60);
  const secondsComponent = wholeSeconds % 60;

  const hourPart = hours > 0 ? `${String(hours).padStart(2, '0')}:` : '';
  const minutePart = `${String(minutes).padStart(2, '0')}`;
  const secondPart = `${String(secondsComponent).padStart(2, '0')}`;
  const fractionPart = fractionDigits > 0 ? `.${String(fractional).padStart(fractionDigits, '0')}` : '';

  return `${hourPart}${minutePart}:${secondPart}${fractionPart}`;
}

module.exports = {
  normalizeFilePath,
  formatFileSize,
  formatDate,
  formatTimestamp
};

